<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AuthController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

//    use AuthenticatesUsers;

    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    public function showLoginForm()
    {
        if (Auth::guard()->check()) {
            return redirect()->route('user.dashboard');
        }
        return view('auth.login');
    }

    public function doLogin(Request $request)
    {
        $credentials = ['email' => $request->email, 'password' => $request->password];
        if (Auth::guard("web")->attempt($credentials)) {
            if (Auth::guard("web")->check()) {
               return redirect()->route('dashboard');
                // return response()->json('Login Successful');
            }
            return redirect()->back()->with('error', 'Wrong email / password provided');
        }

        return redirect()->back()->with('error', 'Wrong email / password provided');
    }

    public function logout()
    {
        Auth::logout();
//        return redirect('/login');
        return redirect()->route('login');
    }


}
