<?php

namespace App\Http\Controllers;

use App\Models\Review;
use Illuminate\Http\Request;

class ReviewController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()   
    {
        $reviews = Review::with('place')->get(); 
        // return $reviews;
        return view('review.index' , compact('reviews'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $review = Review::with('place')->findOrFail($id);
    
        // return response()->json($review);
        return view('review.show', compact('review'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        return view('review.edit');
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    
    public function destroy(string $id)
    {
        // Find the review by ID
        $review = Review::find($id);
    
        // Check if the review exists
        if (!$review) {
            // Handle case where review doesn't exist
            return redirect()->route('review.index')->with('error', 'Review not found.');
        }
    
        // Perform deletion
        $review->delete();
    
        // Redirect to index route
        return redirect()->route('review.index')->with('success', 'Review deleted successfully.');
    }
}
