<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ReviewResources extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        // return parent::toArray($request);
        return [
            'id' => $this->id,
            'name' => $this->name,
            'email' => $this->email,
            'image' => asset('storage/' . $this->image),
            'place_id' => $this->place_id,
            'username' => $this->username,
            'star_rating' => $this->star_rating,
            'comments' => $this->comments,
            'location' =>   $this->location,

        ];
    }
}
