<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Review extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $fillable = ['place_id', 'username', 'email', 'star_rating', 'comments', 'location', 'image']; // Define fillable fields

    public function place()
    {
        return $this->belongsTo(Place::class);
    }
}
