<?php

namespace Database\Seeders;

use App\Models\Game;
use App\Models\Review;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Storage;

class ReviewSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
                
                // $games = Game::all();

            
                // $reviews = [];
        
                // foreach ($games as $game) {
                //     $reviews[] = [
                //         'game_id' => $game->id,
                //         'username' => 'User1',
                //         'email' => 'user1@example.com',
                //         'star_rating' => rand(1, 5),
                //         'comments' => 'This is a dummy review for '.$game->title,
                //         'location' => 'Dummy Location',
                //         'created_at' => now(),
                //         'updated_at' => now()
                //     ];
                // }
        
                
                // Review::insert($reviews);

                $reviews = [
                    [
                        'place_id' => 1,
                        'username' => 'john_doe',
                        'email' => 'john@example.com',
                        'star_rating' => 4,
                        'comments' => 'Great place!',
                        'location' => 'New York',
                        'image_path' => 'images/cat.png',
                    ],
                    [
                        'place_id' => 2,
                        'username' => 'jane_smith',
                        'email' => 'jane@example.com',
                        'star_rating' => 5,
                        'comments' => 'Amazing experience!',
                        'location' => 'Los Angeles',
                        'image_path' => 'images/qss.png',
                    ],
                    // Add more sample review data as needed
                ];
        
                // Seed the database with reviews
                foreach ($reviews as $reviewData) {
                    // Handle image seeding
                    if (isset($reviewData['image_path'])) {
                        $imagePath = $reviewData['image_path'];
                        unset($reviewData['image_path']);
                        $reviewData['image'] = $imagePath; 
                    }
        
                    // Create review
                    Review::create($reviewData);
                }
    }
}
