@extends('layouts.app')
@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        {{-- @dd($reviews) --}}
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Review List</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item active">Review List</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">

            <!-- Default box -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Review List</h3>

                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                        <button type="button" class="btn btn-tool" data-card-widget="remove" title="Remove">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body p-0">
                    <table class="table table-striped projects">
                        <thead>
                            <tr>
                                <th style="width: 1%">
                                    #
                                </th>
                                <th style="width: 20%">
                                    Place Name
                                </th>
                                <th style="width: 30%">
                                    Reviewer Name
                                </th>
                                <th>
                                    Rating
                                </th>
                                <th style="width: 8%" class="text-center">
                                    Comments
                                </th>
                                <th style="width: 20%">
                                </th>
                            </tr>
                        </thead>
                        @foreach ($reviews as $review)
                            {{-- <p>{{ $review->username }}</p> --}}

                            <tbody>
                                <tr>
                                    <td>
                                        #
                                    </td>
                                    <td>
                                        <a>

                                            {{ $review->place->title }}
                                        </a>
                                    </td>
                                    <td>
                                        <a>
                                            {{ $review->username }}
                                        </a>
                                    </td>
                                    <td class="project_progress">
                                        <a> {{ $review->star_rating }} out of 5</a>
                                    </td>
                                    <td class="project-state">
                                        <span class="">{{ $review->comments }}</span>
                                    </td>
                                    <td class="project-actions text-right">
                                        <a class="btn btn-primary btn-sm"
                                            href="{{ route('review.show', ['id' => $review->id]) }}">
                                            <i class="fas fa-folder">
                                            </i>
                                            View
                                        </a>
                                    {{-- <form method="post" action="{{ route('invoice.destroy', [$invoice->id]) }}">
                                    @csrf
                                    @method('delete')
                                    <button type="submit" class="show-confirm" class="delete"><i
                                            class="fa-solid fa-trash btn btn-danger"></i></button>
                                </form> --}}
                                <form method="post" action="{{ route('review.destroy', [$review->id]) }}" >
                                    @csrf
                                    @method('delete')
                                    <button type="submit" class="fa-solid fa-trash btn btn-danger"><i
                                        class="fa-solid fa-trash"></i>Delete</button>

                                </form> 
                                    </td>
                                </tr>
                            </tbody>
                        @endforeach
                    </table>
                </div>
                <!-- /.card-body -->
            </div>
            <!-- /.card -->

        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
@endsection
