<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\ReviewController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

// Route::get('/', function () {
//     return view('main');
// });
Route::get('login',[AuthController::class, "showLoginForm"])->name('login');
Route::post('do/login',[AuthController::class, "doLogin"])->name('do.login');

Route::middleware('auth')->group( function(){
     Route::post('logout',[AuthController::class, "logout"])->name('logout');
     Route::get('/', [HomeController::class, 'index'])->name('home');
     Route::get('/dashboard', [HomeController::class, 'dashboard'])->name('dashboard');
     Route::get('/review', [ReviewController::class, 'index'])->name('review.index');
     Route::get('/review/{id}', [ReviewController::class, 'show'])->name('review.show');
     Route::get('/review/{id}/edit', [ReviewController::class, 'edit'])->name('review.edit');
     Route::put('/review/{id}', [ReviewController::class, 'update'])->name('review.update');
     Route::delete('/review-delete/{id}', [ReviewController::class, 'destroy'])->name('review.destroy');
 } );

